<?php
// Altered Tables

// Add the usergroup field
if (self::$db_alter->fetch_table_info('forum'))
{
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_usertag_enabletag',
		'type'       => 'tinyint',
		'length'     => '1',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '1'
	));
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_usertag_enablemention',
		'type'       => 'tinyint',
		'length'     => '1',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '1'
	));
	self::report('Altered Table', 'forum');
}

if (self::$db_alter->fetch_table_info('user'))
{
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_usertag_settings',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::report('Altered Table', 'user');
}

if (!$existing = self::$db->query_first_slave("SELECT bbcodetag FROM " . TABLE_PREFIX . "bbcode WHERE bbcodetag = 'mention'"))
{
	// BBCode didn't exist
	
	// Ensure we can rebuild BBCode cache
	require_once(DIR . '/includes/adminfunctions.php');
	
	// Insert the BBCode
	self::$db->query_write("
		INSERT INTO `" . TABLE_PREFIX . "bbcode`
			(`bbcodetag`, `bbcodereplacement`, `bbcodeexample`, `bbcodeexplanation`, `twoparams`, `title`, `buttonimage`, `options`)
		VALUES (
			'mention',
			'@%1$s;',
			'[mention]Username[/mention]',
			'Mention an user to alert him or her to this post!',
			0,
			'Mention',
			'dbtech/usertag/images/mention.png',
			1
		)
	");
	self::report('Populated Table', 'bbcode');
	
	build_bbcode_cache();
}
?>